
/*++
INTEL CONFIDENTIAL
Copyright 2005-2015 Intel Corporation All Rights Reserved.

The source code contained or described herein and all documents
related to the source code ("Material") are owned by Intel Corporation
or its suppliers or licensors. Title to the Material remains with
Intel Corporation or its suppliers and licensors. The Material
contains trade secrets and proprietary and confidential information of
Intel or its suppliers and licensors. The Material is protected by
worldwide copyright and trade secret laws and treaty provisions. No
part of the Material may be used, copied, reproduced, modified,
published, uploaded, posted, transmitted, distributed, or disclosed in
any way without Intel's prior express written permission.

No license under any patent, copyright, trade secret or other
intellectual property right is granted to or conferred upon you by
disclosure or delivery of the Materials, either expressly, by
implication, inducement, estoppel or otherwise. Any license under such
intellectual property rights must be express and approved by Intel in
writing.
--*/


/*
File Name:
   Fwu_Common.h
Abstract:
   Definitions for the Fw Update Kernel Service.
Author
   Kingsley Adeoye
*/


#ifndef _FWU_COMMON_H
#define  _FWU_COMMON_H

#if !CSE_SPS_CONF_ENABLE

#include "version_struct.h"
#include "mkhi_hdrs.h"
#include "cse_basic_types.h"

typedef unsigned int STATUS;

//#define     FW_UPDATE_STATUS           unsigned int

#define BLACK_LIST_ENTRY_MAX           10
#define FWU_PWD_MAX_SIZE               32
#define MAXIMUM_IPU_SUPPORTED          20
#define MAXIMUM_IPU_SUPPORTED_ME11     4 
#define HASH_SHA256_LEN                32
#define FWU_HECI_CLIENT_MAX_MSG_SIZE   4096

#define FPT_PARTITION_NAME_UPDT 0x54445055
#define FPT_PARTITION_NAME_ISHC 0x43485349

// Safe Update States
#define         SU_STATE0_NO_UPDATE                         0  
#define         SU_STATE1_COPY_FT_TO_NFTP_BEGIN             1
#define         SU_STATE1_COPY_FT_TO_NFTP_END               2
#define         SU_STATE2_COPY_ALL_BEGIN                    3
#define         SU_STATE2_COPY_ALL_END                      4
#define         SU_STATE3_CONFIRM_LIVE_PING_BEGIN           5
#define         SU_STATE3_CONFIRM_LIVE_PING_END             6
#define         SU_ROLLBACK1_RECOVER_NFT_BEGIN              7
#define         SU_ROLLBACK1_RECOVER_NFT_END                0           // Back to NO_UPDATE
#define         SU_ROLLBACK2_RECOVER_ALL_BEGIN              8
//#define         SU_FORCE_ROLLBACK2_RECOVER_ALL              9
#define         SU_ROLLBACK2_RECOVER_ALL_END                0           // Back to NO_UPDATE

// From FwuHeciMsgs.h
/* HMRFPO_GETSTATUS_CMD_STATUS and HMRFPOState Values*/
#define     HMRFPO_DISABLED 0
#define     HMRFPO_LOCKED   1
#define     HMRFPO_ENABLED  2

/** \addtogroup fwupdate 
  <b>HMRFPO_ENABLE</b> Data structure: 
  \li \ref _FWUPDATE_HMRFPO_ENABLE_DATA
  \li \ref _FWUPDATE_HMRFPO_ENABLE
  \li \ref _FWUPDATE_HMRFPO_ENABLE_ACK_DATA
  \li \ref _FWUPDATE_HMRFPO_ENABLE_ACK  
*/ 
 
// ***************************************
/* HMRFPO Related Enums                 */
// ***************************************
/** \addtogroup fwupdate 
  HMRFPO_ENABLE_CMD_ACK_STATUS codes: 
  \code 
     #define     HMRFPO_ENABLE_SUCCESS     0
     #define     HMRFPO_LOCKED             1
     #define     HMRFPO_NVAR_FAILURE       2
     #define     HMRFPO_TDT_FAILURE        3
     #define     HMRFPO_EOP_FAILURE        4
     #define     HMRFPO_ENABLE_UNKNOWNFAIL 5
  \endcode
*/

/* HMRFPO_ENABLE_CMD_ACK_STATUS */
#define     HMRFPO_ENABLE_SUCCESS     0
#define     HMRFPO_LOCKED             1
#define     HMRFPO_NVAR_FAILURE       2
#define     HMRFPO_TDT_FAILURE        3
#define     HMRFPO_EOP_FAILURE        4
#define     HMRFPO_ENABLE_UNKNOWNFAIL 5


/** \addtogroup fwupdate 
   <b>HMRFPO_LOCK</b> Data structure: 
  \li \ref _FWUPDATE_HMRFPO_LOCK
  \li \ref _FWUPDATE_HMRFPO_LOCK_ACK_DATA
  \li \ref _FWUPDATE_HMRFPO_LOCK_ACK 
*/ 

/** \addtogroup fwupdate 
  HMRFPO_LOCK_CMD_ACK_STATUS codes: 
  \code 
   #define     HMRFPO_LOCK_SUCCESS         0
   #define     HMRFPO_LOCK_MANUF_MODE_FAIL 1
  \endcode
*/

/* HMRFPO_LOCK_CMD_ACK_STATUS */
#define     HMRFPO_LOCK_SUCCESS     0
#define     HMRFPO_LOCK_MANUF_MODE_FAIL 1

#if 1
/**
 * @brief The operation completed successfully.
 */
#define STATUS_SUCCESS                0x0

//
//STATUS_SIZE_ERROR
//    The size of the specified object (memory pool, stack, message queue, 
//    etc.) is invalid. 
//
#define STATUS_SIZE_ERROR             0x5

//
//STATUS_NOT_AVAILABLE
//    An attempt to remove a mutex on which a thread is suspended has been 
//    attempted.
// 
#define STATUS_NOT_AVAILABLE          0x1D

//
//STATUS_NOT_FOUND
//    The requested item could not be found.
// 
#define STATUS_NOT_FOUND              0x81

//
//STATUS_INVALID_HANDLE
//    The provided handle does not exist.
//
#define CSE_STATUS_INVALID_HANDLE         0x83

//
//STATUS_INVALID_ACCESS
//    An attempt was made to access an inaccessible or unavailable object.
//
#define STATUS_INVALID_ACCESS         0x84

//
//STATUS_INVALID_PARAMS
//    One or more parameters are invalid.
// 
#define STATUS_INVALID_PARAMS         0x85

//
//STATUS_NOT_READY
//    The h/w device is not ready.
// 
#define STATUS_NOT_READY              0x88

//
//STATUS_NOT_SUPPORTED
//    The function, message or request is not recognized or supported.
// 
#define STATUS_NOT_SUPPORTED          0x89

//
//STATUS_DEVICE_ERROR
//    The h/w device reported an error while attempting the operation.
// 
#define STATUS_DEVICE_ERROR           0x8B      // * spi_flash_write() failed
                                                // * spi_flash_erase() failed
                                                // * spi_flash_read() failed

//
//STATUS_INVALID_ADDRESS
//    The address provided in invalid.
// 
#define STATUS_INVALID_ADDRESS        0x8C

//
//STATUS_INVALID_COMMAND
//    The requested command is unrecognized or invalid.
// 
#define STATUS_INVALID_COMMAND        0x8D

//
//STATUS_STACK_OVERFLOW 
//    The request caused a stack overflow.
//
#define STATUS_STACK_OVER_FLOW        0x8E

//
//STATUS_BUFFER_TOO_SMALL
//    The provided buffer is too small to hold the requested data.
// 
#define STATUS_BUFFER_TOO_SMALL       0x8F

//
//STATUS_INVALID_BUFFER 
//    The buffer was not the proper size for the request.
//
#define STATUS_INVALID_BUFFER         0x91

//
//STATUS_NO_RESPONSE
//    No response was received from the requested target.
// 
#define STATUS_NO_RESPONSE            0x92

//
//STATUS_TIMED_OUT
//    The device or object timed out and was unable to complete the request.
// 
#define STATUS_TIMED_OUT              0x93

// 
//STATUS_NOT_STARTED
//    The requested operation could not be started.  For protocols, this 
//    error indicates the protocol has not been started.
//
#define STATUS_NOT_STARTED            0x94

//
//STATUS_ALREADY_STARTED
//    The requested operation has already been started.  
//    - For protocols, this error 
//    indicates the protocol has already been started.  
//    - For Policy Manager this error means
//    that the MKHI group ID is already registered.
//    For FW update, we only allow one process to do the update at a time, this means error
//    case where FW update is already in progress, the current process will have to try later.
// 
#define STATUS_ALREADY_STARTED        0x95

//
//STATUS_OUT_OF_RESOURCES
//    Insufficient resources to perform the request. Used by components operating
//    in non-blocking mode. A caller will be returned this error when a component
//    does not have enough resources like command buffers, PRDs etc... to entertain
//    a new request.
//
#define STATUS_OUT_OF_RESOURCES       0x9D

//
//STATUS_FAILURE
//    A unknown error encountered while performing a requested transaction.
//
#define STATUS_FAILURE                0x9E

//
//STATUS_IMAGE_INVALID
//    The FW Update image content is invalid.
#define STATUS_IMAGE_INVALID           0xA5

// STATUS_UPDATE_MISMATCH_HW_SKU 
//    Indicates that there is a mismatch between the current HW SKU and the 
//    one in the new image.
#define STATUS_UPDATE_MISMATCH_HW_SKU  0xB6

// STATUS_UPDATE_MISMATCH_FW_SKU 
//    Indicates that there is a mismatch between the current FW SKU and the 
//    one in the new image.
#define STATUS_UPDATE_MISMATCH_FW_SKU  0xB7

// STATUS_UPDATE_MISMATCH_VERSION 
//    Indicates that there is a mismatch between the current FW version and the 
//    one in the new image.
#define STATUS_UPDATE_MISMATCH_VERSION 0xB8

//
//STATUS_OUT_OF_MEMORY
//    This error can be returned for the following reasons: 
//       1.Attempt to allocate memory and no memory is available
//       2.Attempt to free a memory block on which a thread is suspended
//    NOTE: This value is the same a as STATUS_START_ERROR.
// 
#define STATUS_OUT_OF_MEMORY              0xBE

// STATUS for FWU kernel between  0x200  to 0x2FF
#define FW_UPDATE_STATUS UINT32

#define   NO_UPDATE  0
#define   STATUS_UPDATE_SUCCESS                                               0x000 // Zero for sucess anything else is consider failures 
#define   STATUS_UPDATE_IMAGE_INVALID                                         0x201 // Not used
#define   STATUS_UPDATE_INTEGRITY_FAILURE                                     0x202 
#define   STATUS_UPDATE_SKU_MISMATCH                                          0x203 // * Sku capabilities bits are different between the Update Image and the Flash Image.
#define   STATUS_UPDATE_FW_VERSION_MISMATCH                                   0x204 // * Major version number of Update Image is not the same as major version number of Flash Image.
#define   STATUS_UPDATE_GENERAL_FAILURE                                       0x205    
#define   STATUS_UPDATE_OUT_OF_RESOURCES                                      0x206 // * malloc returned NULL. The heap size of FWUpdate process is not big enough. Happens when working in DEBUG, when the image is too big. This is why FW Update is not supported in DEBUG. (Need to increase heap size and partitions sizes).
#define   STATUS_UPDATE_AUDIT_POLICY_FAILURE                                  0x207
#define   STATUS_UPDATE_ERROR_CREATING_FT                                     0x208 // * The total size of the backup partitions is bigger than NFTP size. Can happen in Consumer, when not setting fixed partitions sizes in build.
#define   STATUS_UPDATE_SAL_NOTIFICATION_ERROR                                0x209 // * Bug: Publish event failed (FW Update process publishes events to notify that FW Update is starting).
#define   STATUS_UPDATE_IMG_LOADING                                           0x20A // * Update Image is being transferred to FW through Heci.
#define   STATUS_UPDATE_IMG_AUTHENTICATING                                    0x20B // * Update Image is being authenticated (signatures, lengths, hashs, ...).
#define   STATUS_UPDATE_IMG_PROCESSING                                        0x20C // * Actual FW Update started (writing to the Flash after authenticating the Update Image).
#define   STATUS_UPDATE_CREATING_FT                                           0x20D // * Status in GetLastUpdateStatus(): FW Update process is creating a backup of FTPR on NFTP.
#define   STATUS_UPDATE_UPDATING_CODE                                         0x20E // * Status in GetLastUpdateStatus(): FW Update process is updating the new FTPR.
#define   STATUS_UPDATE_UPDATING_NFT                                          0x20F // * Status in GetLastUpdateStatus(): FW Update process is updating the new NFTP.
#define   STATUS_UPDATE_FLASH_CODE_PARTITION_INVALID                          0x210 // * Status in GetLastUpdateStatus(): FTPR is backed-up on NFTP and original FTPR is corrupted, CSE is in Recovery Mode. When this error is returned in other cases: Bug: FTPR partition (even the backup) in the Flash is invalid. In UpdateFlashImageInfo().
#define   STATUS_UPDATE_FLASH_NFT_PARTITION_INVALID                           0x211 // * Status in GetLastUpdateStatus(): NFTP is corrupted, CSE is in Recovery Mode.
#define   STATUS_UPDATE_ILLEGAL_IMAGE_LENGTH                                  0x212
#define   STATUS_UPDATE_NOT_READY                                             0x213
                                                                              
#define   STATUS_UPDATE_HOST_RESET_REQUIRED                                   0x214
#define   STATUS_INVALID_GLUT                                                 0x215
#define   STATUS_INVALID_OEM_ID                                               0x216
                                                                              
// New for CPT add below here                                                 
#define   STATUS_UPDATE_IMAGE_BLACKLISTED                                     0x217    //New SPT
#define   STATUS_UPDATE_IMAGE_VERSION_HISTORY_CHECK_FAILURE                   0x218    //New SPT
#define   STATUS_UPDATE_DOWNGRADE_VETOED                                      0x219
#define   STATUS_UPDATE_WRITE_FILE_FAILURE                                    0x22A
#define   STATUS_UPDATE_READ_FILE_FAILURE                                     0x22B
#define   STATUS_UPDATE_DELETE_FILE_FAILURE                                   0x22C
#define   STATUS_UPDATE_PARTITION_LAYOUT_NOT_COMPATIBLE                       0x22D    // FW Update is not possible due to partition move //New SPT - partition sizes
#define   STATUS_DOWNGRADE_NOT_ALLOWED_DATA_MISMATCHED                        0x22E
#define   STATUS_UPDATE_FW_UPDATE_IS_DISABLED                                 0x22F
#define   STATUS_UPDATE_PASSWORD_NOT_MATCHED                                  0x230
#define   STATUS_UPDATE_PASSWORD_EXCEED_MAXIMUM_RETRY                         0x231
#define   STATUS_UPDATE_INRECOVERY_MODE_RESTRICT_UPDATE_TO_ATTEMPTED_VERSION  0x232    // They have to update with the same image that they started with.


// New for Partial FW update
#define   STATUS_UPDATE_UPV_VERSION_MISMATCHED                                0x233    // UPV version mismatched update is not allow
#define   STATUS_UPDATE_INSTID_IS_NOT_EXPECTED_ID                             0x234 // * Partial update is allowed only to the expected instance ID of an IUP. The Update Image contains IUP with instance ID that is not the currently expected one by the FW.
#define   STATUS_UPDATE_INFO_NOT_AVAILABLE                                    0x235    // While in the middle of update IPU attrib info will bot be available
#define   STATUS_UPDATE_REJ_IPU_FULL_UPDATE_NEEDED                            0x236 // * Partial Update is not allowed, because CSE is in Recovery Mode.
#define   STATUS_UPDATE_IPU_NAMEID_NOT_FOUND                                  0x237 // * Partial Update of an IUP was requested, but this IUP doesn't exist in the Flash Image.

#define   STATUS_UPDATE_RESTORE_POINT_INVALID                                 0x238 // * Update to Restore Point Image: comparing the hash of the image to the saved hashes of last 10 Restore Point Images that were created previously, did not find a match. This means that the image is not a Restore Point Image.
#define   STATUS_UPDATE_RESTORE_POINT_VALID_BUT_NOT_LATEST                    0x239
#define   STATUS_UPDATE_RESTORE_POINT_OPERATION_NOT_ALLOWED                   0x23A // * Get Restore Point Image is not allowed, because FW Update is in progress. (The regular FW Update will continue).
#define   STATUS_DOWNGRADE_NOT_ALLOWED_SVN_RESTRICTION                        0x23B // * Update to Image with lower SVN is not allowed.
#define   STATUS_DOWNGRADE_NOT_ALLOWED_VCN_RESTRICTION                        0x23C // * Update to Image with lower VCN is not allowed.
#define   STATUS_INVALID_SVN                                                  0x23D // * SVN invalid: SVN larger than 254 is not allowed.
#define   STATUS_UPDATE_OUT_OF_SVN_RESOURCES                                  0x23E // * PSVN partition is full, so cannot update to higher SVN.
#define   STATUS_UPDATE_REJECT_RESTORE_POINT_REQUEST_FLASH_IN_RECOVERY        0x23F // * Restore Point Image was requested, but it is not allowed because CSE is in Recovery Mode.
#define   STATUS_UPDATE_REJECTED_BY_UPDATE_POLICY                             0x240
#define   STATUS_UPDATE_REJECTED_INCOMPATIBLE_TOOL_USAGE                      0x241
#define   STATUS_UPDATE_REJECTED_CROSSPOINT_UPDATE_NOT_ALLOWED                0x242
#define   STATUS_UPDATE_REJECTED_CROSSHOTFIX_UPDATE_NOT_ALLOWED               0x243
#define   STATUS_UPDATE_REJECTED_CURRENT_FW_NOT_ELIGIBLE_FOR_UPDATE           0x244
#define   STATUS_UPDATE_REJECTED_WRONG_UPDATE_OPERATION                       0x245
#define   STATUS_UPDATE_REJECTED_WRONG_UPDATE_IMAGE_FOUND                     0x246
#define   STATUS_UPDATE_REJECTED_IFR_UPDATE_NOT_ALLOWED                       0x247
#define   STATUS_UPDATE_FAILURE_OCCURRED_DURING_ROLLBACK                      0x248

// New for SPT add below here
#define   STATUS_UPDATE_FW_ENGINEERING_VERSION_NOT_ALLOWED                    0x249
#define   STATUS_UPDATE_FW_ENGINEERING_VERSION_REQUIRED                       0x24A
#define   STATUS_UPDATE_FW_RESTORE_HISTORY_NOT_FOUND                          0x24B
#define   STATUS_UPDATE_API_VERSION_MISMATCH                                  0x24C
#define   STATUS_UPDATE_REJECT_UPDATE_PG_IN_PROGRESS                          0x24D // * FW Update process called to PG entry override (sys_pg_override()) at the start of the update, but PG is in progress.

#define   STATUS_UPDATE_REJECT_RESTORE_POINT_REQUEST_RESTART_NEEDED           0x24E // Restore Point Image was requested, but there was Full/Partial FW Update before without Restart after it.
#define   STATUS_UPDATE_PMC_INSTANCE                                          0x24F // Update to incompatible PMC: The instance ID is different, which means H/LP incompatibility between the Update Image and the Flash Image.
#define   STATUS_UPDATE_H_LP_MISMATCH                                         0x250 // Update to incompatible H/LP image. The Sku Capabilities h/lp bits are different between the Update Image and the Flash Image.

#define   STATUS_UPDATE_UPD_IMG_TOO_BIG                                       0x251 // Update Image length is bigger than the expected size of the image according to its size in the flash. For example: Error on updating from Consumer to Corporate, or from REL to DBG. Or when partitions sizes were changed in make file in the last kit version (when finalizing the partition sizes before releasing a CSE project).
#define   STATUS_UPDATE_INVALID_MANIFEST_SIZE                                 0x252 // Manifest size in Update Image is bigger than 8KB, or exceeds the Update Image size.
#define   STATUS_UPDATE_OPEN_LDR_VER_MAN_FAILED                               0x253 // Failed to open loader (DEV_FD_LDR_VERIFY_MAN) to verify manifest.
#define   STATUS_UPDATE_OPEN_LDR_KEYS_FAILED                                  0x254 // Failed to open loader (DEV_FD_LDR_VERIFY_MAN) to install / uninstall keys.
#define   STATUS_UPDATE_INSTALL_KEYS_FAILED                                   0x255 // ldr_install_keys() failed - install ROT and OEM keys (to verify manifest signatures by Loader). This can happen when doing Update between pre-production and production images (since the ROT / OEM keys don't match).
#define   STATUS_UPDATE_UNINSTALL_KEYS_FAILED                                 0x256 // ldr_uninstall_keys() failed - uninstall keys for OEM partitions (ISHC/IUNP).
#define   STATUS_UPDATE_OPEN_LDR_INSTALL_FAILED                               0x257 // Failed to open loader (DEV_FD_LDR_INSTALL) to install pre-update module.
#define   STATUS_UPDATE_INSTALL_FAILED                                        0x258 // ldr_install_modules() failed - install pre-update module.
#define   STATUS_UPDATE_PREUPDATE_VFS                                         0x259 // Failed to create dir or files for preupdate module (permissions, quota).
#define   STATUS_UPDATE_SPAWN_FAILED                                          0x25A // spawn() of pre-update module failed - might be permissions problem.
#define   STATUS_UPDATE_WAITPID_FAILED                                        0x25B // waitpid() to pre-update module failed.
#define   STATUS_UPDATE_PREUPDATE_FAILED                                      0x25C // Pre-Update module process returned error exit code after it was run.
#define   STATUS_UPDATE_SKUMGR_FAILED                                         0x25D // Call to sku_mgr functions failed.
#define   STATUS_UPDATE_CFGMGR_FAILED                                         0x25E // Call to cfgmgr functions failed. cfgmgr_get_rule(), cfgmgr_set_rule().
#define   STATUS_UPDATE_MAN_NOT_FOUND                                         0x25F // Manifest not found in partition (in Update or Flash Image).
#define   STATUS_UPDATE_CRYPTO_FAILED                                         0x260 // Crypto operation (calculating hash of partition) failed.
#define   STATUS_UPDATE_VER_MAN_FAILED_FTPR                                   0x261 // Loader failed to verify manifest signature of FTPR. Production vs. Pre-Production.
#define   STATUS_UPDATE_VER_MAN_FAILED_NFTP                                   0x262 // Loader failed to verify manifest signature of NFTP.
#define   STATUS_UPDATE_VER_MAN_FAILED_DLMP                                   0x263 // Loader failed to verify manifest signature of IDLM.
#define   STATUS_UPDATE_VER_MAN_FAILED_RBEP                                   0x264 // Loader failed to verify manifest signature of RBE.
#define   STATUS_UPDATE_VER_MAN_FAILED_PMCP                                   0x265 // Loader failed to verify manifest signature of PMC.
#define   STATUS_UPDATE_VER_MAN_FAILED_OEMP                                   0x266 // Loader failed to verify manifest signature of OEM KM.
#define   STATUS_UPDATE_VER_MAN_FAILED_WCOD                                   0x267 // Loader failed to verify manifest signature of WCOD.
#define   STATUS_UPDATE_VER_MAN_FAILED_LOCL                                   0x268 // Loader failed to verify manifest signature of LOCL.
#define   STATUS_UPDATE_VER_MAN_FAILED_PAVP                                   0x269 // Loader failed to verify manifest signature of PAVP.
#define   STATUS_UPDATE_VER_MAN_FAILED_IOMP                                   0x26A // Loader failed to verify manifest signature of IOMP.
#define   STATUS_UPDATE_VER_MAN_FAILED_MGPP                                   0x26B // Loader failed to verify manifest signature of MGPP.
#define   STATUS_UPDATE_VER_MAN_FAILED_TBTP                                   0x26C // Loader failed to verify manifest signature of TBTP.
#define   STATUS_UPDATE_VER_MAN_FAILED_ISHC                                   0x26D // Loader failed to verify manifest signature of ISHC.
#define   STATUS_UPDATE_VER_MAN_FAILED_IUNP                                   0x26E // Loader failed to verify manifest signature of IUNIT.
#define   STATUS_UPDATE_VER_MAN_FAILED_UPDT                                   0x26F // Loader failed to verify manifest signature of Pre-Update Module.
#define   STATUS_UPDATE_GET_EXT_FAILED_FTPR                                   0x270 // Some manifest extension is missing in FTPR.
#define   STATUS_UPDATE_GET_EXT_FAILED_NFTP                                   0x271 // Some manifest extension is missing in NFTP.
#define   STATUS_UPDATE_GET_EXT_FAILED_DLMP                                   0x272 // Some manifest extension is missing in IDLM.
#define   STATUS_UPDATE_GET_EXT_FAILED_RBEP                                   0x273 // Some manifest extension is missing in RBE.
#define   STATUS_UPDATE_GET_EXT_FAILED_PMCP                                   0x274 // Some manifest extension is missing in PMC. Wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_GET_EXT_FAILED_OEMP                                   0x275 // Some manifest extension is missing in OEM KM. Wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_GET_EXT_FAILED_WCOD                                   0x276 // Some manifest extension is missing in WCOD.
#define   STATUS_UPDATE_GET_EXT_FAILED_LOCL                                   0x277 // Some manifest extension is missing in LOCL.
#define   STATUS_UPDATE_GET_EXT_FAILED_PAVP                                   0x278 // Some manifest extension is missing in PAVP. Wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_GET_EXT_FAILED_IOMP                                   0x279 // Some manifest extension is missing in IOMP. Wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_GET_EXT_FAILED_MGPP                                   0x27A // Some manifest extension is missing in MGPP. Wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_GET_EXT_FAILED_TBTP                                   0x27B // Some manifest extension is missing in TBTP. Wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_GET_EXT_FAILED_ISHC                                   0x27C // Some manifest extension is missing in ISHC. Wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_GET_EXT_FAILED_IUNP                                   0x27D // Some manifest extension is missing in IUNIT. Wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_GET_EXT_FAILED_UPDT                                   0x27E // Some manifest extension is missing in Pre-Update Module.
#define   STATUS_UPDATE_INTEGRITY_FAILED_FTPR                                 0x27F // FTPR partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_NFTP                                 0x280 // NFTP partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_DLMP                                 0x281 // DLMP partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_RBEP                                 0x282 // RBEP partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_PMCP                                 0x283 // PMCP partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_OEMP                                 0x284 // OEMP partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_WCOD                                 0x285 // WCOD partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_LOCL                                 0x286 // LOCL partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_PAVP                                 0x287 // PAVP partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_IOMP                                 0x288 // IOMP partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_MGPP                                 0x289 // MGPP partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_TBTP                                 0x28A // TBTP partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_ISHC                                 0x28B // ISHC partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_IUNP                                 0x28C // IUNP partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_INTEGRITY_FAILED_UPDT                                 0x28D // UPDT partition hash and calculated hash are not the same. If partition hash is zero - wrong MEU Tool was used to create the partition.
#define   STATUS_UPDATE_PART_SIZE                                             0x28E // The size of an Update partition size is bigger than the size of the Flash partition.
#define   STATUS_UPDATE_BACKUP_OUTSIDE_NFTP                                   0x28F // Location of partition to backup is not inside NFTP.
#define   STATUS_UPDATE_MAX_IUPS                                              0x290 // The number of IUPs in the Update/Flash Image is bigger than MAX_IUPS.
#define   STATUS_UPDATE_NOT_IUP                                               0x291 // Partition name inside IUPs list (in FTPR manifest extension) is not IUP.
#define   STATUS_UPDATE_IUP_MISSING_UPDATE                                    0x292 // Non-optional IUP (like LOCL, WCOD) inside IUPs list (in FTPR manifest extension) is not in the Update Image.
#define   STATUS_UPDATE_PMC_MISSING_UPDATE                                    0x293 // PMC partition is not in the Update Image.
#define   STATUS_UPDATE_NOT_PARTIAL_IUP                                       0x294 // It is not allowed to do Partial Update on this partition.
#define   STATUS_UPDATE_PARTIAL_TCSS                                          0x295 // It is not allowed to do Partial Update on Type-C partitions, according to NVAR.
#define   STATUS_UPDATE_FTPR_VER                                              0x296 // RBEP and NFTP must have the same version as FTPR, in the Update Image.
#define   STATUS_UPDATE_FTPR_SVN                                              0x297 // RBEP and NFTP must have the same SVN as FTPR, in the Update Image.
#define   STATUS_UPDATE_FTPR_VCN                                              0x298 // RBEP and NFTP must have the same VCN as FTPR, in the Update Image.
#define   STATUS_UPDATE_FTPR_VER_MAJOR                                        0x299 // Non-optional IUPs (like LOCL, WCOD) must have the same major build version as FTPR, in the Update Image for Full Update, in the Flash Image for Partial Update.
#define   STATUS_UPDATE_IUP_SVN                                               0x29A // Update IUP must not have SVN smaller than SVN of Flash IUP.
#define   STATUS_UPDATE_IUP_VCN                                               0x29B // Update IUP must not have VCN smaller than VCN of Flash IUP.
#define   STATUS_UPDATE_IMAGE_LEN                                             0x29C // Update Image length is not the same as Flash Image length.
#define   STATUS_UPDATE_PV_BIT                                                0x29D // Update from PV bit ON to PV bit OFF is not allowed.
#define   STATUS_UPDATE_REVENUE                                               0x29E // Update to PV bit OFF on Revenue platform is not allowed.
#define   STATUS_UPDATE_SVN_UPGRADE                                           0x29F // Update to higher SVN must be an upgrade - to higher build version.
#define   STATUS_UPDATE_SVN_HOTFIX                                            0x2A0 // Update to higher SVN must be to a higher Hot Fix number (the third number in the build version).
#define   STATUS_UPDATE_API_VER_MAJOR_FTPR                                    0x2A1 // Place holder. This error code will not be returned by the FW.
#define   STATUS_UPDATE_API_VER_MAJOR_NFTP                                    0x2A2 // Place holder. This error code will not be returned by the FW.
#define   STATUS_UPDATE_API_VER_MAJOR_DLMP                                    0x2A3 // Place holder. This error code will not be returned by the FW.
#define   STATUS_UPDATE_API_VER_MAJOR_RBEP                                    0x2A4 // Place holder. This error code will not be returned by the FW.
#define   STATUS_UPDATE_API_VER_MAJOR_PMCP                                    0x2A5 // PMCP must have the same major API version as the version inside the list in FTPR, in the Update Image for Full Update.
#define   STATUS_UPDATE_API_VER_MAJOR_OEMP                                    0x2A6 // OEMP must have the same major API version as the version inside the list in FTPR, in the Update Image for Full Update.
#define   STATUS_UPDATE_API_VER_MAJOR_WCOD                                    0x2A7 // WCOD must have the same major API version as the version inside the list in FTPR, in the Update Image for Full Update, in the Flash Image for Partial Update.
#define   STATUS_UPDATE_API_VER_MAJOR_LOCL                                    0x2A8 // LOCL must have the same major API version as the version inside the list in FTPR, in the Update Image for Full Update, in the Flash Image for Partial Update.
#define   STATUS_UPDATE_API_VER_MAJOR_PAVP                                    0x2A9 // PAVP must have the same major API version as the version inside the list in FTPR, in the Update Image for Full Update, in the Flash Image for Partial Update.
#define   STATUS_UPDATE_API_VER_MAJOR_IOMP                                    0x2AA // IOMP must have the same major API version as the version inside the list in FTPR, in the Update Image for Full Update, in the Flash Image for Partial Update.
#define   STATUS_UPDATE_API_VER_MAJOR_MGPP                                    0x2AB // MGPP must have the same major API version as the version inside the list in FTPR, in the Update Image for Full Update, in the Flash Image for Partial Update.
#define   STATUS_UPDATE_API_VER_MAJOR_TBTP                                    0x2AC // TBTP must have the same major API version as the version inside the list in FTPR, in the Update Image for Full Update, in the Flash Image for Partial Update.
#define   STATUS_UPDATE_API_VER_MAJOR_ISHC                                    0x2AD // ISHC must have the same major API version as the version inside the list in FTPR, in the Update Image for Full Update, in the Flash Image for Partial Update.
#define   STATUS_UPDATE_API_VER_MAJOR_IUNP                                    0x2AE // IUNP must have the same major API version as the version inside the list in FTPR, in the Update Image for Full Update, in the Flash Image for Partial Update.
#define   STATUS_UPDATE_API_VER_MAJOR_UPDT                                    0x2AF // Place holder. This error code will not be returned by the FW.
#define   STATUS_UPDATE_IUP_MISSING_FLASH                                     0x2B0 // Non-optional IUP (like LOCL, WCOD) inside IUPs list (in FTPR manifest extension) is not in the Flash Image.
#define   STATUS_UPDATE_PARTITION_NOT_FOUND                                   0x2B1 // A partition that was searched in the Update Image is not in it.
#define   STATUS_UPDATE_ENGINEERING_MISMATCH                                  0x2B2 // Update between engineering build vs regular build is not allowed. Both builds have to be the same type: regular or engineering build. Engineering build is 7000 and above. Regular build is below 7000.
#define   STATUS_UPDATE_OEMP_MISSING                                          0x2B3 // OEM KM partition is not in the Update Image, but ISHC/IUNP is in the Update Image, which is not allowed.
#define   STATUS_UPDATE_IUPS_NOT_COMPATIBLE                                   0x2B4 // ISHC/IUNP do not exist in the same way in the Update Image and in the Flash Image.
#define   STATUS_UPDATE_OEMP_IN_UPDATE                                        0x2B5 // OEM KM partition is not in the Flash Image, but it is in the Update Image, which is not allowed.
#define   STATUS_UPDATE_WRONG_IUP                                             0x2B6 // Partial FW Update: the Update Image contains IUP that is different than the one that was requested to be updated in the Partial Update command.
#define   STATUS_UPDATE_IMAGE_IUP_SIZE                                        0x2B7 // The Partial Update Image size is different than the size of the IUP in it (as it is in the manifest). This means that the Update Image contains more (or less) than the IUP partition.
#define   STATUS_UPDATE_OPEN_IUP                                              0x2B8 // Bug: Open of IUP path failed. Need to add the path in Storage, or add permissions to FW Update process.
#define   STATUS_UPDATE_SPI_IUP                                               0x2B9 // Bug: spi_flash_partition_updated() failed. This updates the files (in the file system) of the newly updated IUP, after Partial Update (without reset).
#define   STATUS_UPDATE_RULE_FILE_INVALID                                     0x2BA // Update Rule file contains invalid value. (This file holds the MEBX option for FW Update: values: disable / enable / password protected).
#define   STATUS_UPDATE_PWDMGR_FAILED                                         0x2BB // Call to pwdmgr function failed. pwdmgr_get_mebx_pwd() - to get the ME password, for FW Update that requires password.
#define   STATUS_UPDATE_PWR_FAILED                                            0x2BC // Call to pwr function failed. pwr_state_get_last_reset_reason().
#define   STATUS_UPDATE_SPI_FAILED                                            0x2BD // Call to spi function failed. spi_flash_get_override_strap().
#define   STATUS_UPDATE_RESTORE_POINT_ALREADY_STARTED                         0x2BE // Get Restore Point Image is not allowed, because a previous Get Restore Point operation already started. Both operations will be aborted. (Get Restore Point can be started again after this).
#define   STATUS_UPDATE_RESTORE_POINT_OFFSET_INVALID                          0x2BF // Bug: Get Restore Point Image Data: The offset of Restore Point Image is bigger than the Image length.
#define   STATUS_UPDATE_WRONG_HECI_MSG_LENGTH                                 0x2C0 // Heci message length is not as expected.
#define   STATUS_UPDATE_ENV_INVALID                                           0x2C1 // FWU_START_MSG Heci message contains invalid value in UpdateEnvironment. Value should be FWU_ENV_MANUFACTURING. (Other possible value: FWU_ENV_IFU is obsolete).
#define   STATUS_UPDATE_WRONG_DATA_OPERATION                                  0x2C2 // FWU_DATA Heci command was sent, but the FW Update wasn't started with FWU_START Heci command before it.
#define   STATUS_UPDATE_DATA_LENGTH_INVALID                                   0x2C3 // FWU_DATA Heci command has invalid data length (too big).
#define   STATUS_UPDATE_WRONG_END_OPERATION                                   0x2C4 // FWU_END Heci command was sent, but there was no FWU_DATA command before it.
#define   STATUS_UPDATE_FLUSH_NVM_ERR                                         0x2C5 // Error when flushing NVM to UMA space (before rewriting flash).
#define   STATUS_UPDATE_IPK_FAILURE                                           0x2C6 // clear_ipk_valid_bit() returned error. This function prevents CSE from entering M3 after FW Update, and instead CSE will go into MOff.
#define   STATUS_UPDATE_PG_FAILURE                                            0x2C7 // FW Update process called to PG entry override (sys_pg_override()) at the start of the update, and it returned error.
#define   STATUS_UPDATE_INVALID_FLASH_IMAGE                                   0x2C8 // Flash Image content is invalid (partitions/manifests sizes, locations, structures).
#define   STATUS_UPDATE_INVALID_UPDATE_IMAGE                                  0x2C9 // Wrong structure of Update Image (manifests, $CPD), complete_partition_length is 0, no module or metadata of preupdate inside UPDT partition.
#define   STATUS_SVN_TCB_ARB                                                  0x2CA // Update to higher TCB SVN must be also to higher ARB SVN.

//.........................................................................
//.........................................................................            // Reserve for FWU usage
#define   STATUS_UPDATE_LAST_STATUS_CODE                                      0x2FF 

// means internal FW operation errors 
//#define   STATUS_UPDATE_UNKNOWN = 0xFFFFFFFF


#endif


#pragma pack(1)
// From FwuHeciMsgs.h
// MKHI CMD Defs
typedef enum 
{
   FWUPDATE_HMRFPO_ENABLE_CMD = 0x01,
   FWUPDATE_HMRFPO_LOCK_CMD,
   FWUPDATE_HMRFPO_GETSTATUS_CMD,
   FWUPDATE_HMRFPO_DISABLE_CMD,
   FWU_GET_IMAGE_FW_VERSION_CMD, 

   FWUPDATE_HMRFPO_ENABLE_CMD_ACK = 0x81,
   FWUPDATE_HMRFPO_LOCK_CMD_ACK,
   FWUPDATE_HMRFPO_GETSTATUS_CMD_ACK,
   FWUPDATE_HMRFPO_DISABLE_CMD_ACK,
   FWU_GET_IMAGE_FW_VERSION_CMD_ACK

} FWUPDATE_HMRFPO_MKHI_COMMANDS;

// ***************************************
/* Fixed address MKHI FWUPDATE messaging commands Group ID 0x06 for FW update*/
// ***************************************
typedef enum 
{
   FWUPDATE_RESUME_CMD = 0x01,
   FWUPDATE_QUERY_STATUS_CMD,
   FWUPDATE_FORCE_SAFE_BOOT_CMD,

   FWUPDATE_RESUME_CMD_ACK = 0x81,
   FWUPDATE_QUERY_STATUSCMD_ACK,
   FWUPDATE_FORCE_SAFE_BOOT_ACK,

} FWUPDATE_MKHI_COMMANDS;

// From MeTypes.h
// Enums for the FLASH image possible states and Update states.
//
typedef enum _FLASH_IMAGE_STATUS
{
   IMAGE_VALID = 0,
   IMAGE_CODE_INVALID,
   IMAGE_NFT_INVALID,
   IMAGE_CREATING_FT,    // Make backup of FT, or copy FT to NFTP partition for IFR
   IMAGE_UPDATING_CODE,
   IMAGE_UPDATING_NFT,

   IMAGE_STATUS_UNKNOWN = 0xFFFFFFFF

} FLASH_IMAGE_STATUS;

typedef enum _FWU_HECI_MSG_STATUS{
      FWU_NOT_READY,
      FWU_ILLEGAL_LENGTH, //allocate image buffer
} FWU_HECI_MSG_STATUS;

typedef enum _BLACK_LIST_EXPRESSION_TYPES
{
   BLE_EMPTY = 0,
   BLE_EQ,
   BLE_LTE,
   BLE_GTE,
   BLE_RANGE
}BLACK_LIST_EXPRESSION_TYPES;

typedef enum _FWU_OPERATION
{
   FWU_FULL_UPDATE_OPERATION   =   0,
   FWU_IPU_UPDATE_OPERATION
}FWU_OPERATION;

typedef enum _FWU_ENVIRONMENT
{
   FWU_ENV_MANUFACTURING = 0,   // Manufacturing update
   FWU_ENV_IFU,                 // Independent Firmware update
}FWU_ENVIRONMENT;

typedef enum _FWU_ROLLBACK_MODE
{
   FWU_ROLLBACK_NONE = 0,       // No rollback
   FWU_ROLLBACK_1,              // Rollback 1 procedure
   FWU_ROLLBACK_2,              // Rollback 2 procedure
}FWU_ROLLBACK_MODE;

typedef enum _FWU_RECOVERY_MODE
{
   FWU_RECOVERY_NONE = 0,       // No recovery
   FWU_RECOVERY_FULL = 1,       // Full recovery mode
   FWU_RECOVERY_PARTIAL = 2     // Partial Recovery Mode
}FWU_RECOVERY_MODE;
typedef struct _FWU_INFO_FLAGS
{
   unsigned int RecoveryMode:2;   // 0 = No recovery; 1 = Full Recovery Mode,2 = Partial Recovery Mode
   unsigned int IpuNeeded:1;      // IPU_NEEDED bit, if set we are in IPU_NEEDED state.
   unsigned int FwInitDone:1;     // If set indicate FW is done initialized
   unsigned int FwuInProgress:1;  // If set FWU is in progress, this will be set for IFU update as well
   unsigned int SuInprogress:1;   // If set IFU Safe FW update is in progress. 
   unsigned int NewFtTestS:1;     // If set indicate that the new FT image is in Test Needed state (Stage 2 Boot)
   unsigned int SafeBootCnt:4;    // Boot count before the operation is success
   unsigned int FsbFlag:1;        // Force Safe Boot Flag, when this bit is set, we'll boot kernel only and go into recovery mode   

   //////////////////////////////////////////////////////
   // These fields below are important for FWU tool. 
   //////////////////////////////////////////////////////
   unsigned int LivePingNeeded:1;     // Use for IFU only, See Below  
                                // FWU tool needs to send Live-Ping or perform querying to confirm update successful.
                                // With the current implementation when LivePingNeeded is set, 
                                // Kernel had already confirmed it. No action from the tool is needed.
   unsigned int ResumeUpdateNeeded:1; // Use for IFU only, If set FWU tool needs to resend update image
   unsigned int RollbackNeededMode:2; // FWU_ROLLBACK_NONE = 0, FWU_ROLLBACK_1, FWU_ROLLBACK_2 
                                // If not FWU_ROLLBACK_NONE, FWU tool needs to send restore_point image. 
   unsigned int ResetNeeded:2;        // When this field is set to ME_RESET_REQUIRED, FW Kernel will
                                // perform ME_RESET after this message. No action from the tool is needed.
   unsigned int SuState:4;          // See possible values below
   unsigned int RecoveryCause:2;      // IMAGE_CODE_INVALID = 1; IMAGE_NFT_INVALID = 2;
   unsigned int Reserve:8;
}FWU_INFO_FLAGS;


typedef struct    _BLACK_LIST_ENTRY
{
   unsigned short   ExpressionType;
   unsigned short   MinorVer;
   unsigned short   HotfixVer1;
   unsigned short   BuildVer1;
   unsigned short   HotfixVer2;
   unsigned short   BuildVer2;
}BLACK_LIST_ENTRY;


//Data
typedef struct _FWU_HECI_MESSAGE_DATA
{
   unsigned int   Length;
   unsigned char    Reserved[3];
   unsigned char    Data[1];
} FWU_HECI_MESSAGE_DATA;


typedef struct _PT_ATTRB
{
   unsigned int PtNameId; // FPT_PARTITION_NAME_WCOD         0x444f4357 OR 
                      // FPT_PARTITION_NAME_LOCL         0x4C434F4C OR
                      // FPT_PARTITION_NAME_ISHC         0x43485349 OR
                      // FPT_PARTITION_NAME_IUNP         0x504E5549 OR
                      // FPT_PARTITION_NAME_PMCP         0x50434D50 OR
                      // FPT_PARTITION_NAME_OEMP         0x504D454F
   unsigned int   LoadAddress;         // Load Address of the IPU
   version  FwVer;         // FW version from IUP Manifest
   unsigned int   CurrentInstId; // Current Inst ID from flash, 0 indicate invalid ID 
   unsigned int   CurrentUpvVer; // Upper sig 16 bits are Major Version.
   unsigned int   ExpectedInstId;// Expected Inst ID that need to be updated to
   unsigned int   ExpectedUpvVer;// Upper sig 16 bits are Major Version.
   unsigned int   Resv[4];
}PT_ATTRB;
C_ASSERT(sizeof(PT_ATTRB) == 48);


typedef struct _RESTORE_POINT_IPU_ATTR
{
    unsigned int   PartitionId;           // WCOD, LOCL, MDMV
    version  FwVer;                 // FW version from IUP Manifest
    unsigned int   CurrentInstId;         // Current Inst ID from flash, 0 indicate invalid ID 
    unsigned int   CurrentUpvVer;         // Upper sig 16 bits are Major Version.
}RESTORE_POINT_IPU_ATTR;
C_ASSERT(sizeof(RESTORE_POINT_IPU_ATTR) == 20);


typedef struct _OEM_UUID
{
   unsigned int Data1;
   unsigned short Data2;
   unsigned short Data3;
   unsigned char Data4 [ 8 ];
} OEM_UUID;


typedef struct _FWU_RESTORE_POINT_INFO
{
    unsigned char           HashCalculated[HASH_SHA256_LEN];
    version  FwVer; // FT Firmware version
    RESTORE_POINT_IPU_ATTR RestAttr[MAXIMUM_IPU_SUPPORTED];
    unsigned int          RESERVE;
}FWU_RESTORE_POINT_INFO;
C_ASSERT(sizeof(FWU_RESTORE_POINT_INFO) == 444);


typedef struct _UPDATE_VERSION_INFO
{
   version  Version;
   unsigned char    History[4];
   unsigned int   CriticalHotfixDescriptor;

}UPDATE_VERSION_INFO;


typedef struct _UPDATE_FLAGS
{
   unsigned int RestorePoint:1;           // If set indicate restore point 
   unsigned int RestartOperation:1;       // If set indicate restart operation, like lost hard drive etc...
   unsigned int UserRollback:1;     // indicates user has initiated a rollback
   unsigned int Reserve:29;               // 
}UPDATE_FLAGS;


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////// ME FWU related Information that will be provided by discovery DLL /////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 
// ME_FWU_INFO General information related to FW update
// Few basic rules:
// Do not delete member, allow add new member only to the end of this struct.
// The producer(Kernel) will only copy up to the size of the consumer StructSize. Consumer must set the StructSize.
// TBD each field need to initialize to invalid pattern? In the case that we could not get 
// the information. 
typedef struct  _ME_FWU_INFO
{
   unsigned int      StructSize;          // SizeOfThisStruct
   unsigned int      ApiVer;              // Version of this API  Major in upper 16 bits
   version     FtpVer;              // QWORD Major(15:0), Minor(31:16), HotFix(47:32), 
                                    // Build#(63:48)
   version     NftpVer;             // QWORD Major(15:0), Minor(31:16), HotFix(47:32), 
                                    // Build#(63:48)
   unsigned int      ChipsetVer;          // PCH version
   unsigned int      GlobalChipId;        // Global chip identification
   unsigned char       SystemManufacturer[32]; // Ascii of char string 

   unsigned int      MebxFwuConfig;       // 0= Disable, 1 = enable , 2 = PW protected
   unsigned int      HwSku;             // MEFWCAPS_SKU   HW feature set or not
   unsigned int      FwSku;             // MEFWCAPS_SKU   FW feature set from 
                                    // SkuTable fuse or not fuse  
   unsigned int      LastFwUpdateStatus;  // Last FW update status
   unsigned int      DataFormatVer;       // Data format version Major(31:16), Minor (15:0). Only Major is used
   unsigned int      SvnVer;              // Security version number
   unsigned int      VcnVer;              // Version Control Number
                                    // This field is currently not used
/* Warning *********************************************************************/                                    
// Do not delete member, allow add new member only to the end of this struct.
/* Warning *********************************************************************/                                    
   version     MebxVer;             // MEBX version 
   FWU_INFO_FLAGS  FwuInfoFlags;    // FWU information flags
   unsigned int  PlatformAttributes;        // ME_PLATFORM_TYPE Contains Platform Attributes: 
                                    // CpuType,platform type, superSku,etc. See ME_PLATFORM_TYPE
   OEM_UUID    OemId;               // Famous OEM_ID
   unsigned short      MeFwSize;            // Size of FW image in multiple of .5MB
   unsigned char       History[4];          // Keep track of version tree history
                                    // Minor0Predecessor, Minor1Predecessor, Minor2Predecessor, Minor3Predecessor
                                    // FWU will check to see if the update image has the same predecessor with the
                                    // one that is already in the flash before allow the update.
   unsigned int      CriticalHotfixDescriptor;  // Each bit signify a particular Critical Hot Fix
   unsigned int      FwuIFRAllowedRule;   // 1 Aloowed, 0 Disallowed
   FWU_RESTORE_POINT_INFO      LastRestorePointInfo; //Replace old unsigned int      Reserved[29]; 
   unsigned int      FwStatus1;           // Firmware status register 1, use for debugging
   unsigned int      FwStatus2;           // Firmware status register 2, use for debugging   
   unsigned int      Reserve1;            //                     // 
   unsigned short      NumSupportedIup;     // Number of IPUs actually supported, use this number to traverse IupEntry  
   PT_ATTRB    IupEntry [MAXIMUM_IPU_SUPPORTED];  

}ME_FWU_INFO;
C_ASSERT(sizeof(ME_FWU_INFO) == 1556);


// Typedef for the commands serviced by the Fw Update service
typedef enum _FWU_HECI_MESSAGE_TYPE
{
   FWU_GET_VERSION = 0,
   FWU_GET_VERSION_REPLY,
   FWU_START,
   FWU_START_REPLY,
   FWU_DATA,
   FWU_DATA_REPLY,
   FWU_END,
   FWU_END_REPLY,
   FWU_GET_INFO,
   FWU_GET_INFO_REPLY,
   FWU_GET_FEATURE_STATE,
   FWU_GET_FEATURE_STATE_REPLY,
   FWU_GET_FEATURE_CAPABILITY,
   FWU_GET_FEATURE_CAPABILITY_REPLY,
   FWU_GET_PLATFORM_TYPE,
   FWU_GET_PLATFORM_TYPE_REPLY,
   FWU_VERIFY_OEMID,
   FWU_VERIFY_OEMID_REPLY,
   FWU_GET_OEMID,
   FWU_GET_OEMID_REPLY,
   FWU_IMAGE_COMPATABILITY_CHECK,
   FWU_IMAGE_COMPATABILITY_CHECK_REPLY,
   FWU_GET_UPDATE_DATA_EXTENSION,
   FWU_GET_UPDATE_DATA_EXTENSION_REPLY,
   FWU_GET_RESTORE_POINT_IMAGE,
   FWU_GET_RESTORE_POINT_IMAGE_REPLY,
   //FWU_GET_RECOVERY_MODE,
   //FWU_GET_RECOVERY_MODE_REPLY,
   FWU_GET_IPU_PT_ATTRB,
   FWU_GET_IPU_PT_ATTRB_REPLY,
   FWU_GET_FWU_INFO_STATUS,
   FWU_GET_FWU_INFO_STATUS_REPLY,
   GET_ME_FWU_INFO,
   GET_ME_FWU_INFO_REPLY,
   FWU_CONFIRM_LIVE_PING,
   FWU_CONFIRM_LIVE_PING_REPLY,
   FWU_VERIFY_PWD,
   FWU_VERIFY_PWD_REPLY,
   FWU_GET_RESTORE_POINT_IMAGE_DATA,
   FWU_GET_RESTORE_POINT_IMAGE_DATA_REPLY,
   FWU_INVALID_REPLY = 0xFF
} FWU_HECI_MESSAGE_TYPE;


/**
 * FWU_FLASH_IMAGE_START_MSG - start the update process
 *
 * @MessageType: FWU_FLASH_IMAGE_START_MSG
 */
typedef struct _FWU_FLASH_IMAGE_START_MSG_REPLY
{
   STATUS   Status;
   unsigned int   Resv[4];
}FWU_FLASH_IMAGE_START_MSG_REPLY;


/**
 * FWU_GET_VERSION_MSG - start the update process
 *
 * @MessageType: FWU_GET_VERSION_MSG
 */
// Struct definition below here //
typedef struct _FWU_GET_VERSION_MSG_REPLY
{
   unsigned int      MessageType;
   unsigned int      Status;
   unsigned int      Sku;       
   unsigned int      PCHVer;
   unsigned int      Vendor;
   unsigned int      LastFwUpdateStatus;
   unsigned int      HwSku;
   version     CodeVersion;
   version     AMTVersion;
   unsigned short      EnabledUpdateInterfaces;   // local, remote (LMS/LME) and secure update
   unsigned short      SvnInFlash;                // Security version of image that is already in flash
   unsigned int      DataFormatVersion;         // Upper 16 sig bits for Major version lower 16's for Minor Version
   unsigned int      LastUpdateResetType;       // Last successfull update partition reset type prior to reboot. After reboot, it should be zero
} FWU_GET_VERSION_MSG_REPLY;


/**
 * FWU_START_MSG - start the update process
 *
 * @MessageType: FWU_START_MSG
 */
typedef struct _FWU_START_MSG
{
   unsigned int   MessageType;     
   unsigned int   Length;           // Length of update image
   unsigned int   UpdtLength;       // Length of preupdate partition
   unsigned char    UpdateType;       // 0 Full update, 1 partial IPU pdate
   unsigned char    PassWordLength;   // Length of password not include NULL
   unsigned char    PassWordData[FWU_PWD_MAX_SIZE];  // Password data not include NULL byte
   unsigned int   IpuIdTobeUpdated; // Only for Partial FWU
   unsigned int   UpdateEnvironment;// 0 default to normal manufacturing use 
                              // 1 is for Emergency IFU update 
   UPDATE_FLAGS UpdateFlags;    
   OEM_UUID OemId;
   unsigned int   Resv[4];
} FWU_START_MSG;


typedef struct _FWU_START_MSG_REPLY
{
   unsigned int   MessageType;
   STATUS   Status;
   unsigned int   Resv[4];

}FWU_START_MSG_REPLY;


/**
 * FWU_DATA_MSG - send data during the update process
 *
 * @MessageType: FWU_DATA_MSG
 */
 typedef struct _FWU_DATA_MSG
{
   unsigned int   MessageType;
   unsigned int   Length;
   unsigned char    Reserved[3];
   unsigned char    Data[1];
} FWU_DATA_MSG;


typedef struct _FWU_DATA_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS Status;
}FWU_DATA_MSG_REPLY;


/**
 * FWU_END_MSG - end the update process
 *
 * @MessageType: FWU_END_MSG
 */
typedef struct _FWU_END_MESSAGE
{
    unsigned int MessageType;
} FWU_END_MESSAGE;

typedef struct _FWU_END_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS Status; // 0 indicate success, else failure
   unsigned int ResetType; 
   unsigned int Resv[4];

}FWU_END_MSG_REPLY;


/**
 * FWU_GET_INFO_MSG - get info
 *
 * @MessageType: FWU_GET_INFO_MSG
 */
typedef struct _FWU_GET_INFO_MSG
{
   unsigned int MessageType;
} FWU_GET_INFO_MSG;

// Contains the data to be returned for GET_VERSION command
typedef struct _FWU_GET_INFO_MSG_REPLY{
   unsigned int          MessageType;
   unsigned int          Status;
   version         MEBxVersion;
   unsigned int          FlashOverridePolicy;
   unsigned int          MangeabilityMode;
   unsigned int          BiosBootState;
   struct {
     unsigned int        CryptoFuse   :1;
     unsigned int        FlashProtection:1; // read from SPI driver
     unsigned int        Obsolete_FwOverrideQualifier:2;
     unsigned int        MeResetReason:2; // Reset.h
     unsigned int        Obsolete_FwOverrideCounter:8; //TO DO: change this in MeTypes.h to unsigned char
     unsigned int        reserved:18;
    }Fields;
   unsigned char          BiosVersion[20];

}FWU_GET_INFO_MSG_REPLY;


/**
 * FWU_GET_FEATURE_STATE_MSG - get info
 *
 * @MessageType: FWU_GET_FEATURE_STATE_MSG
 */
typedef struct _FWU_GET_FEATURE_STATE_MSG_REPLY
{
   unsigned int      MessageType;
   unsigned int      Status;
   unsigned int      FeatureState;       
} FWU_GET_FEATURE_STATE_MSG_REPLY;


/**
 * FWU_GET_PLATFORM_TYPE_MSG - get plat type
 *
 * @MessageType: FWU_GET_PLATFORM_TYPE_MSG
 */
typedef struct _FWU_GET_PLATFORM_TYPE_MSG_REPLY
{
   unsigned int      MessageType;
   unsigned int      Status;
   unsigned int      PlatformType;       
} FWU_GET_PLATFORM_TYPE_MSG_REPLY;


/**
 * FWU_VERIFY_OEMID_MSG - verify OEMID
 *
 * @MessageType: FWU_VERIFY_OEMID_MSG
 */
typedef struct _FWU_VERIFY_OEMID_MSG
{
   unsigned int  MessageType;
   OEM_UUID      OemId;
} FWU_VERIFY_OEMID_MSG;

typedef struct _FWU_VERIFY_OEMID_MSG_REPLY
{
   unsigned int  MessageType;
   unsigned int Status;
}FWU_VERIFY_OEMID_MSG_REPLY;


/**
 * FWU_GET_OEMID_MSG - verify OEMID
 *
 * @MessageType: FWU_GET_OEMID_MSG
 */
typedef struct _FWU_GET_OEMID_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS        Status;
   OEM_UUID      OemId;
} FWU_GET_OEMID_MSG_REPLY;


/**
 * FWU_IMAGE_COMPATABILITY_CHECK_MSG - verify image compatability
 *
 * @MessageType: FWU_IMAGE_COMPATABILITY_CHECK_MSG
 */
typedef struct _FWU_IMAGE_COMPATABILITY_CHECK_MSG
{
   unsigned int   MessageType;
   unsigned int   ManifestLength;      // Manifest Len
   unsigned char    Reserved[3];
   unsigned char    ManifestBuffer[1];   // At least one element 
                                 // otherwise compiling error when use WATCOM compiler
}FWU_IMAGE_COMPATABILITY_CHECK_MSG;



typedef struct _FWU_IMAGE_COMPATABILITY_CHECK_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS      Status;  // 0 is OK for update, else failures
                        // Possible error code 
                        // STATUS_UPDATE_READ_FILE_FAILURE
                        // STATUS_UPDATE_FW_VERSION_MISMATCH
                        // STATUS_UPDATE_IMAGE_INVALID
                        // STATUS_UPDATE_FLASH_CODE_PARTITION_INVALID
                        // STATUS_UPDATE_IMAGE_VERSION_HISTORY_CHECK_FAILURE
                        // STATUS_UPDATE_IMAGE_BLACKLISTED
}FWU_IMAGE_COMPATABILITY_CHECK_MSG_REPLY;


/**
 * FWU_GET_UPDATE_DATA_EXTENSION_MSG - verify image compatability
 *
 * @MessageType: FWU_GET_UPDATE_DATA_EXTENSION_MSG
 */
typedef struct _FWU_GET_UPDATE_DATA_EXTENSION_MSG
{
    unsigned int MessageType;
} FWU_GET_UPDATE_DATA_EXTENSION_MSG;

typedef struct _FWU_GET_UPDATE_DATA_EXTENSION_MSG_REPLY
{
   unsigned int       MessageType;
   STATUS       Status;          // 0 for success, other failure and the info is invalid
   unsigned char        History[4];      // Minor0Predecessor, Minor1Predecessor, Minor2Predecessor, Minor3Predecessor
   unsigned int       CriticalHotfixDescriptor;
   BLACK_LIST_ENTRY     BlackList[BLACK_LIST_ENTRY_MAX];
}FWU_GET_UPDATE_DATA_EXTENSION_MSG_REPLY;


/**
 * FWU_GET_RESTORE_POINT_IMAGE_MESSAGE - get restore point image
 *
 * @MessageType: FWU_GET_RESTORE_POINT_IMAGE_MESSAGE
 */
typedef struct _FWU_GET_RESTORE_POINT_IMAGE_MESSAGE
{
    unsigned int MessageType;
} FWU_GET_RESTORE_POINT_IMAGE_MESSAGE;

typedef struct _FWU_GET_RESTORE_POINT_IMAGE_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS  Status;
   unsigned int  RestorePointImageSize; // Size of image is in Bytes
   unsigned int  RestorePointImage[1];
}FWU_GET_RESTORE_POINT_IMAGE_MSG_REPLY;


/**
 * FWU_GET_RESTORE_POINT_IMAGE_MESSAGE - get restore point image
 *
 * @MessageType: FWU_GET_RESTORE_POINT_IMAGE_MESSAGE
 */
typedef struct _FWU_GET_RESTORE_POINT_IMAGE_DATA_MESSAGE
{
    unsigned int MessageType;
} FWU_GET_RESTORE_POINT_IMAGE_DATA_MESSAGE;

typedef struct _FWU_GET_RESTORE_POINT_IMAGE_DATA_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS  Status;
   unsigned int RestorePointImageOffset;
   unsigned int  RestorePointImageDataLength; // Size of image is in Bytes
   unsigned int  RestorePointImage[1];
}FWU_GET_RESTORE_POINT_IMAGE_DATA_MSG_REPLY;


/**
 * FWU_GET_IPU_PT_ATTRB_MSG - get info status
 *
 * @MessageType: FWU_GET_IPU_PT_ATTRB_MSG
 */
typedef struct _FWU_GET_IPU_PT_ATTRB_MSG
{
   unsigned int   MessageType;
   unsigned int   UpdateType;
} FWU_GET_IPU_PT_ATTRB_MSG;

typedef struct _FWU_GET_IPU_PT_ATTRB_MSG_REPLY
{
   unsigned int   MessageType;      // Internal FWU tool use only
   STATUS   Status;           // Internal FWU tool use only
   version  FtpFwVer;         // FW version in Fault Tolerance Partition. 
                              // This might be used for diagnostic or debug.
   unsigned int   SizeoOfPtAttrib;  // Size in bytes. Simply is the sizeof (PT_ATTRB structure)
   unsigned int   NumOfPartition;   // Number of partition actually return in this reply message
   PT_ATTRB  PtAttribute[MAXIMUM_IPU_SUPPORTED];
   unsigned int   Resv[4];
}FWU_GET_IPU_PT_ATTRB_MSG_REPLY;

// This struct is for ME11 and previous versions.
// It is the same as the above struct (FWU_GET_IPU_PT_ATTRB_MSG_REPLY) besides PtAttribute array size (MAXIMUM_IPU_SUPPORTED)
// For ME12 and later, don't use this struct; Use FWU_GET_IPU_PT_ATTRB_MSG_REPLY!
typedef struct _FWU_GET_IPU_PT_ATTRB_MSG_REPLY_ME11
{
   uint32_t MessageType;      // Internal FWU tool use only
   STATUS   Status;           // Internal FWU tool use only
   version  FtpFwVer;         // FW version in Fault Tolerance Partition. 
                              // This might be used for diagnostic or debug.
   uint32_t SizeoOfPtAttrib;  // Size in bytes. Simply is the sizeof (PT_ATTRB structure)
   uint32_t NumOfPartition;   // Number of partition actually return in this reply message
   PT_ATTRB PtAttribute[MAXIMUM_IPU_SUPPORTED_ME11];
   uint32_t Resv[4];
}FWU_GET_IPU_PT_ATTRB_MSG_REPLY_ME11;
/**
 * FWU_GET_FWU_INFO_STATUS_MSG - get info status
 *
 * @MessageType: FWU_GET_FWU_INFO_STATUS_MSG
 */
typedef struct _FWU_GET_FWU_INFO_STATUS_MSG
{
   unsigned int   MessageType;
   unsigned int   InfoParm;         // Not used 
   unsigned int   Resv[4];
}FWU_GET_FWU_INFO_STATUS_MSG;

typedef struct _FWU_GET_FWU_INFO_STATUS_MSG_REPLY
{
   unsigned int   MessageType;
   STATUS   Status;
   FWU_INFO_FLAGS   Flags;
   unsigned int   Resv[4];
}FWU_GET_FWU_INFO_STATUS_MSG_REPLY;


/**
 * ME_FWU_INFO_MSG - get ME firmware update info message
 *
 * @MessageType: ME_FWU_INFO_MSG
 */
typedef struct _ME_FWU_INFO_MSG
{
    unsigned int MessageType;
    unsigned int MessageParams[2]; //Currently not used
}ME_FWU_INFO_MSG;

typedef struct _ME_FWU_INFO_MSG_REPLY
{
    unsigned int                MessageType;
    unsigned int                Status; // 0 = success, else failure
    ME_FWU_INFO         MeFwuInfo;
}ME_FWU_INFO_MSG_REPLY;

/**
 * FWU_CONFIRM_LIVE_PING_MSG - confirm live ping
 *
 * @MessageType: FWU_CONFIRM_LIVE_PING_MSG
 */
typedef struct _FWU_CONFIRM_LIVE_PING_MSG
{
   unsigned int  MessageType;
   unsigned int  Reserve[4];
} FWU_CONFIRM_LIVE_PING_MSG;

typedef struct _FWU_CONFIRM_LIVE_PING_MSG_REPLY
{
   unsigned int  MessageType;
   unsigned int  Status;    // Always STATUS_SUCCESS = 0
   unsigned int  Reserve[4];
}FWU_CONFIRM_LIVE_PING_MSG_REPLY;


/**
 * FWU_VERIFY_PWD_MSG - confirm live ping
 *
 * @MessageType: FWU_VERIFY_PWD_MSG
 */
typedef struct _FWU_VERIFY_PWD_MSG
{
    unsigned int MessageType;
    unsigned char PasswordLength;
    unsigned char PasswordData[FWU_PWD_MAX_SIZE];
}FWU_VERIFY_PWD_MSG;

typedef struct _FWU_VERIFY_PWD_MSG_REPLY    
{
    unsigned int MessageType;
    unsigned int Status;
}FWU_VERIFY_PWD_MSG_REPLY;


/**
 * FWU_INVALID_MSG - confirm live ping
 *
 * @MessageType: FWU_INVALID_MSG
 */
typedef struct _FWU_INVALID_MSG_REPLY
{
   unsigned int  MessageType;
   STATUS Status;
}FWU_INVALID_MSG_REPLY;


//NOTE: WE ARE VERY CLOSE TO MAXIMUM HECI MESSAGE BUFFER SIZE
typedef struct  _FWU_HECI_MSG
{
   union{
      unsigned int  MessageType;
 
      FWU_GET_VERSION_MSG_REPLY        VersionReply;
      FWU_START_MSG                    Start;
      FWU_START_MSG_REPLY              StartReply;
      FWU_DATA_MSG                     Data;
      FWU_DATA_MSG_REPLY               DataReply;
      FWU_END_MSG_REPLY                EndReply;
      FWU_GET_INFO_MSG_REPLY           InfoReply;
      FWU_GET_FEATURE_STATE_MSG_REPLY  FeatureStateReply;
      FWU_GET_PLATFORM_TYPE_MSG_REPLY  PlatformTypeReply;
      FWU_VERIFY_OEMID_MSG             VerifyOemId;
      FWU_VERIFY_OEMID_MSG_REPLY       VerifyOemIdReply;
      FWU_GET_OEMID_MSG_REPLY          GetOemIdReply;
      FWU_IMAGE_COMPATABILITY_CHECK_MSG   ImageCheck;
      FWU_IMAGE_COMPATABILITY_CHECK_MSG_REPLY         ImageCheckReply;
      FWU_GET_UPDATE_DATA_EXTENSION_MSG_REPLY         GetUpdateDataExtReply;
      FWU_GET_RESTORE_POINT_IMAGE_MSG_REPLY           GetRestorePointImageReply;
      FWU_GET_RESTORE_POINT_IMAGE_DATA_MSG_REPLY    GetRestorePointImageDataReply;
      //FWU_GET_RECOVERY_MODE_MSG                       GetRecoveryMode; 
      //FWU_GET_RECOVERY_MODE_MSG_REPLY                 GetRecoveryModeReply; 
      FWU_GET_IPU_PT_ATTRB_MSG                        GetIpuPtAttrb; 
      FWU_GET_IPU_PT_ATTRB_MSG_REPLY                  GetIpuPtAttrbReply;
      FWU_GET_FWU_INFO_STATUS_MSG                     GetFwuInfoStatusMsg;
      FWU_GET_FWU_INFO_STATUS_MSG_REPLY               GetFwuInfoStatusMsgReply;
      ME_FWU_INFO_MSG_REPLY                           GetMeInfoMsgReply;
      FWU_CONFIRM_LIVE_PING_MSG                       ConfirmLivePingMsg;
      FWU_CONFIRM_LIVE_PING_MSG_REPLY                 ConfirmLivePingMsgReply;
      FWU_VERIFY_PWD_MSG            VerifyPwd;
      FWU_VERIFY_PWD_MSG_REPLY          VerifyPwdReply;
      FWU_INVALID_MSG_REPLY            InvalidMsgReply;

   }MessageData;
}FWU_HECI_MSG;
C_ASSERT(sizeof(FWU_HECI_MSG) <= FWU_HECI_CLIENT_MAX_MSG_SIZE); // current size is 612
// ***************************************
/* HMRFPO Message Data Structures       */
// ***************************************

//HMRFPO ENABLE REQ
typedef struct _FWUPDATE_HMRFPO_ENABLE_DATA //unlock
{
   unsigned long long                  Nonce;   //For minisku/BIOS message compatibility
} FWUPDATE_HMRFPO_ENABLE_DATA;

typedef struct _FWUPDATE_HMRFPO_ENABLE
{
   mkhi_message_header_t                 Header;
   FWUPDATE_HMRFPO_ENABLE_DATA         Data;    //For minisku/BIOS message compatibility
} FWUPDATE_HMRFPO_ENABLE;


//HMRFPO ENABLE ACK
typedef struct _FWUPDATE_HMRFPO_ENABLE_ACK_DATA
{
   unsigned int                              FactoryDefaultBase;     //For minisku/BIOS message compatibility
   unsigned int                              FactoryDefaultLimit;    //For minisku/BIOS message compatibility
   unsigned char                               HMRFPO_EN_Status;
   unsigned char                               Rsvd[3];
} FWUPDATE_HMRFPO_ENABLE_ACK_DATA;

typedef struct _FWUPDATE_HMRFPO_ENABLE_ACK
{
   mkhi_message_header_t                 Header;
   FWUPDATE_HMRFPO_ENABLE_ACK_DATA     Data;
} FWUPDATE_HMRFPO_ENABLE_ACK;


//HMRFPO LOCK REQ
typedef struct _FWUPDATE_HMRFPO_LOCK
{
   mkhi_message_header_t                 Header;
} FWUPDATE_HMRFPO_LOCK;


//HMRFPO LOCK ACK
typedef struct _FWUPDATE_HMRFPO_LOCK_ACK_DATA
{
   unsigned long long                              Nonce;
   unsigned int                              FactoryDefaultBase;  //For minisku/BIOS message compatibility
   unsigned int                              FactoryDefaultLimit; //For minisku/BIOS message compatibility
   unsigned char                               HMRFPO_LOCK_Status;
   unsigned char                               Rsvd[3];
} FWUPDATE_HMRFPO_LOCK_ACK_DATA;

typedef struct _FWUPDATE_HMRFPO_LOCK_ACK
{
   mkhi_message_header_t                 Header;
   FWUPDATE_HMRFPO_LOCK_ACK_DATA       Data;
} FWUPDATE_HMRFPO_LOCK_ACK;

//HMRFPO GETSTATUS REQ
typedef struct _FWUPDATE_HMRFPO_GETSTATUS
{
   mkhi_message_header_t                    Header;
} FWUPDATE_HMRFPO_GETSTATUS;


//HMRFPO GETSTATUS ACK
typedef struct _FWUPDATE_HMRFPO_GETSTATUS_ACK_DATA
{
   unsigned char                                  HMRFPO_State;
   unsigned char                                  Rsvd[3];
} FWUPDATE_HMRFPO_GETSTATUS_ACK_DATA;

typedef struct _FWUPDATE_HMRFPO_GETSTATUS_ACK
{
   mkhi_message_header_t                    Header;
   FWUPDATE_HMRFPO_GETSTATUS_ACK_DATA     Data;
} FWUPDATE_HMRFPO_GETSTATUS_ACK;

/*
//HMRFPO DISABLE REQ
typedef struct _FWUPDATE_HMRFPO_DISABLE
{
   mkhi_message_header_t           Header;
} FWUPDATE_HMRFPO_DISABLE;

typedef struct _MKHI_FWUPDATE_HMRFPO_DISABLE
{
   HECI_MESSAGE_HEADER           Header;
   FWUPDATE_HMRFPO_DISABLE       Msg;
} MKHI_FWUPDATE_HMRFPO_DISABLE;

//HMRFPO DISABLE ACK
typedef struct _FWUPDATE_HMRFPO_DISABLE_ACK_DATA
{
   unsigned char                         HMRFPO_DIS_Status;
   unsigned char                         Reserved[3];   //To conform to CBM_TEMPLATE in BUP 
                                                //so sizeof(FWUPDATE_HMRFPO_DISABLE_ACK_DATA) == UINT32
} FWUPDATE_HMRFPO_DISABLE_ACK_DATA;

typedef struct _FWUPDATE_HMRFPO_DISABLE_ACK
{
   mkhi_message_header_t                 Header;
   FWUPDATE_HMRFPO_DISABLE_ACK_DATA    Data;
} FWUPDATE_HMRFPO_DISABLE_ACK;

// FWUPDATE_QUERY_UPDATE_STATUS
typedef struct _FWUPDATE_QUERY_UPDATE_STATUS
{
   mkhi_message_header_t                    Header;
} FWUPDATE_QUERY_UPDATE_STATUS;


//FWUPDATE_QUERY_UPDATE_STATUS_ACK
typedef struct _FWUPDATE_QUERY_UPDATE_STATUS_ACK_DATA
{
   unsigned int                                 PercentComplete;
   unsigned int                                 CurrentStage;         // Current update Stage
   unsigned int                                 TotalStages;          // Total number of update stages
   unsigned int                                 LastUpdateStatus;     // Last FW update status                                                      
} FWUPDATE_QUERY_UPDATE_STATUS_ACK_DATA;

typedef struct _FWUPDATE_QUERY_UPDATE_STATUS_ACK
{
   mkhi_message_header_t                    Header;   // Header.Result = 0 indicate in progress
                                                    // Header.Result = 1 Complete the update
                                                    // Header.Result = 2 Error during the update
   FWUPDATE_QUERY_UPDATE_STATUS_ACK_DATA    QueryAckData;
   unsigned int ResetType;        // Partition reset type
   FWU_INFO_FLAGS   Flags;  // See FWU_INFO_FLAGS
} FWUPDATE_QUERY_UPDATE_STATUS_ACK;
*/

// FWUPDATE_FORCE_SAFE_BOOT_CMD
typedef struct _FWUPDATE_FORCE_SAFE_BOOT_MSG
{
   mkhi_message_header_t                    Header;
} FWUPDATE_FORCE_SAFE_BOOT_MSG;

typedef struct _FWUPDATE_FORCE_SAFE_BOOT_MSG_ACK
{
   mkhi_message_header_t              Header;   // Header.Result = 0 indicate success else failure
   unsigned int                           Data;                   
} FWUPDATE_FORCE_SAFE_BOOT_MSG_ACK;


// FWU_GET_IMAGE_FW_VERSION
typedef struct _FWU_GET_IMAGE_FW_VERSION_Request
{
   mkhi_message_header_t    Header;
} FWU_GET_IMAGE_FW_VERSION_Request;

typedef struct _FWU_GET_IMAGE_FW_VERSION_Response
{
    mkhi_message_header_t   Header;
    uint32_t                NumOfPartition; // Number of partition actually returned in this reply message
    PT_ATTRB                PtAttribute[MAXIMUM_IPU_SUPPORTED]; // IPU attributes entries
} FWU_GET_IMAGE_FW_VERSION_Response;


#pragma pack()

#endif //!CSE_SPS_CONF_ENABLE
#endif  // _FWU_COMMON_H



